class MainGameScene extends Phaser.Scene {
    
    constructor() 
    {
        super({key: "MainGameScene"}); 
    }
    
    preload()
    {
        this.load.image('player-ship', 'assets/images/player-ship.png');
        this.load.image('asteroid-medium', 'assets/images/asteroid-medium-01.png');
    }

    create()
    {
        this.cursors = this.input.keyboard.createCursorKeys();            
        this.asteroidGroup = this.add.group();
        this.bulletGroup = this.add.group();

        this.createPlayerShip();
        this.createAsteroid();          
    }

    update(time, delta)
    {

    }
    
    createPlayerShip()
    {
        let startX = game.config.width / 2;
        let startY = game.config.height - 50;
        
        this.playerShip = this.physics.add.image(startX, startY, 'player-ship');   
        this.playerShip.setImmovable();
    }
    
    createAsteroid() 
    {
        let asteroid = this.physics.add.image(200, 10, 'asteroid-medium');
        asteroid.setVelocity(0, 50);
        
        this.asteroidGroup.add(asteroid);
    }    

}