/**
 * @author       Richard Davey <rich@photonstorm.com>
 * @copyright    2018 Photon Storm Ltd.
 * @license      {@link https://github.com/photonstorm/phaser/blob/master/license.txt|MIT License}
 */

/**
 * Keyboard Codes.
 * 
 * @name Phaser.Input.Keyboard.KeyCodes
 * @enum {integer}
 * @memberOf Phaser.Input.Keyboard
 * @readOnly
 * @since 3.0.0
 */

var KeyCodes = {

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACKSPACE
     */
    BACKSPACE: 8,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.TAB
     */
    TAB: 9,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ENTER
     */
    ENTER: 13,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SHIFT
     */
    SHIFT: 16,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CTRL
     */
    CTRL: 17,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ALT
     */
    ALT: 18,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAUSE
     */
    PAUSE: 19,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CAPS_LOCK
     */
    CAPS_LOCK: 20,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ESC
     */
    ESC: 27,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SPACE
     */
    SPACE: 32,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_UP
     */
    PAGE_UP: 33,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PAGE_DOWN
     */
    PAGE_DOWN: 34,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.END
     */
    END: 35,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.HOME
     */
    HOME: 36,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.LEFT
     */
    LEFT: 37,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.UP
     */
    UP: 38,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.RIGHT
     */
    RIGHT: 39,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.DOWN
     */
    DOWN: 40,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PRINT_SCREEN
     */
    PRINT_SCREEN: 42,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.INSERT
     */
    INSERT: 45,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.DELETE
     */
    DELETE: 46,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ZERO
     */
    ZERO: 48,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.ONE
     */
    ONE: 49,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.TWO
     */
    TWO: 50,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.THREE
     */
    THREE: 51,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FOUR
     */
    FOUR: 52,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FIVE
     */
    FIVE: 53,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SIX
     */
    SIX: 54,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SEVEN
     */
    SEVEN: 55,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.EIGHT
     */
    EIGHT: 56,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NINE
     */
    NINE: 57,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_ZERO
     */
    NUMPAD_ZERO: 96,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_ONE
     */
    NUMPAD_ONE: 97,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_TWO
     */
    NUMPAD_TWO: 98,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_THREE
     */
    NUMPAD_THREE: 99,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_FOUR
     */
    NUMPAD_FOUR: 100,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_FIVE
     */
    NUMPAD_FIVE: 101,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_SIX
     */
    NUMPAD_SIX: 102,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_SEVEN
     */
    NUMPAD_SEVEN: 103,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_EIGHT
     */
    NUMPAD_EIGHT: 104,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.NUMPAD_NINE
     */
    NUMPAD_NINE: 105,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.A
     */
    A: 65,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.B
     */
    B: 66,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.C
     */
    C: 67,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.D
     */
    D: 68,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.E
     */
    E: 69,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F
     */
    F: 70,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.G
     */
    G: 71,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.H
     */
    H: 72,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.I
     */
    I: 73,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.J
     */
    J: 74,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.K
     */
    K: 75,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.L
     */
    L: 76,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.M
     */
    M: 77,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.N
     */
    N: 78,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.O
     */
    O: 79,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.P
     */
    P: 80,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Q
     */
    Q: 81,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.R
     */
    R: 82,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.S
     */
    S: 83,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.T
     */
    T: 84,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.U
     */
    U: 85,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.V
     */
    V: 86,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.W
     */
    W: 87,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.X
     */
    X: 88,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Y
     */
    Y: 89,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.Z
     */
    Z: 90,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F1
     */
    F1: 112,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F2
     */
    F2: 113,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F3
     */
    F3: 114,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F4
     */
    F4: 115,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F5
     */
    F5: 116,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F6
     */
    F6: 117,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F7
     */
    F7: 118,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F8
     */
    F8: 119,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F9
     */
    F9: 120,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F10
     */
    F10: 121,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F11
     */
    F11: 122,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.F12
     */
    F12: 123,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.SEMICOLON
     */
    SEMICOLON: 186,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PLUS
     */
    PLUS: 187,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.COMMA
     */
    COMMA: 188,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.MINUS
     */
    MINUS: 189,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.PERIOD
     */
    PERIOD: 190,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.FORWARD_SLASH
     */
    FORWARD_SLASH: 191,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACK_SLASH
     */
    BACK_SLASH: 220,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.QUOTES
     */
    QUOTES: 222,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.BACKTICK
     */
    BACKTICK: 192,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.OPEN_BRACKET
     */
    OPEN_BRACKET: 219,

    /**
     * @name Phaser.Input.Keyboard.KeyCodes.CLOSED_BRACKET
     */
    CLOSED_BRACKET: 221

};

module.exports = KeyCodes;
